/*
 *********************************************************************
 *
 * trapped!
 * 
 * objects.h
 *
 *********************************************************************
 */

#ifndef OBJECTS_H
#define OBJECTS_H

#define pZ (float)0.5	// Hhe des Augpunktes

const float c=(float)(SCREEN_X/(2*0.5773502691896));

/* Definition der Datenstrukturen */

struct Punkt
{
	float x,y,z;	/* Koordinaten */
};

struct Vertex
{
	struct Punkt P;
};

struct Edge
{
	struct Vertex *start, *end;	/* Start- und Endpunkt der Kante */
};

struct GoraudVector
{
	float nx1,ny1,nz1;		/* Normalvektor im Startpunkt der Kante */
	float nx2,ny2,nz2;		/* Normalvektor im Endpunkt der Kante */
};

struct Face
{
	struct Face *next;			/* nchste Flche des Objekts */
	struct Edge *edges[4];		/* Kanten der Flche (max. 4) */
	float nx,ny,nz;				/* Normalvektor der Flche */	
	struct {unsigned char r,g,b;} col;	/* Farbe der Flche */
	struct GoraudVector gv[4];	/* Goraudvektoren der Flche */
};

struct Object
{
	struct Face *faces;	/* Flchen des Objekts */
};

struct BildKante		/* Struktur fr die berechneten Gertekoordinaten */
{
	int x1,y1,x2,y2;
	float intensity[2];	/* Lichtintensitt der Eckpunkte */
	float k;			/* Steigung in y-Richtung */
};

/* Definition der vorhandenen Punkte */
struct Vertex vertices[] =
{
	{(float)0.05,(float)0.08660254,0},
	{(float)0.1,0,0},
	{(float)0.05,(float)-0.08660254,0},
	{(float)-0.05,(float)-0.08660254,0},
	{(float)-0.1,0,0},
	{(float)-0.05,(float)0.08660254,0},
	{(float)0.05,(float)0.08660254,(float)0.2},
	{(float)0.1,0,(float)0.2},
	{(float)0.05,(float)-0.08660254,(float)0.2},
	{(float)-0.05,(float)-0.08660254,(float)0.2},
	{(float)-0.1,0,(float)0.2},
	{(float)-0.05,(float)0.08660254,(float)0.2},
	{(float)0.005,(float)0.008660254,(float)0.4},
	{(float)0.01,0,(float)0.4},
	{(float)0.005,(float)-0.008660254,(float)0.4},
	{(float)-0.005,(float)-0.008660254,(float)0.4},
	{(float)-0.01,0,(float)0.4},
	{(float)-0.005,(float)0.008660254,(float)0.4},
	{(float)0.2,(float)0.2,0},
	{(float)0.3,0,0},
	{(float)0.2,(float)-0.2,0},
	{(float)-0.2,0,0},
	{(float)0.2,(float)0.2,(float)0.2},
	{(float)0.3,0,(float)0.2},
	{(float)0.2,(float)-0.2,(float)0.2},
	{(float)-0.2,0,(float)0.2},
// 26
	{(float)0.4,0,0},
	{(float)0.4,(float)0.008660254,(float)0.005},
	{(float)0.4,(float)0.008660254,(float)0.015},
	{(float)0.4,0,(float)0.02},
	{(float)0.4,(float)-0.008660254,(float)0.015},
	{(float)0.4,(float)-0.008660254,(float)0.005},
	{(float)-0.4,0,0},
	{(float)-0.4,(float)0.008660254,(float)0.005},
	{(float)-0.4,(float)0.008660254,(float)0.015},
	{(float)-0.4,0,(float)0.02},
	{(float)-0.4,(float)-0.008660254,(float)0.015},
	{(float)-0.4,(float)-0.008660254,(float)0.005},
	{(float)0.4,(float)-0.025980762,(float)0.005},
	{(float)0.3,(float)-0.025980762,(float)0.005},
	{(float)0.3,(float)-0.025980762,(float)0.015},
	{(float)0.4,(float)-0.025980762,(float)0.015},
	{(float)0.3,(float)-0.008660254,(float)0.005},
	{(float)0.3,(float)-0.008660254,(float)0.015},
	{(float)-0.3,(float)0.034641016,(float)0.005},
	{(float)-0.4,(float)0.034641016,(float)0.005},
	{(float)-0.4,(float)0.034641016,(float)0.015},
	{(float)-0.3,(float)0.034641016,(float)0.015},
	{(float)-0.3,(float)0.008660254,(float)0.005},
	{(float)-0.3,(float)0.008660254,(float)0.015},
	{(float)-0.3,(float)-0.034641016,(float)0.005},
	{(float)-0.4,(float)-0.034641016,(float)0.005},
	{(float)-0.4,(float)-0.034641016,(float)0.015},
	{(float)-0.3,(float)-0.034641016,(float)0.015},
	{(float)-0.3,(float)-0.008660254,(float)0.005},
	{(float)-0.3,(float)-0.008660254,(float)0.015},
// 56
	{(float)-0.5,(float)0.5,0},
	{(float)0.5,(float)0.5,0},
	{(float)0.5,(float)0.5,(float)0.3},
	{(float)0.2,(float)0.5,(float)0.3},
	{(float)-0.1,(float)0.5,(float)0.3},
	{(float)-0.5,(float)0.5,(float)0.3},
	{(float)0.2,(float)0.5,(float)0.6},
	{(float)-0.1,(float)0.5,(float)0.6},
	{(float)-0.1,(float)0.5,(float)0.9},
	{(float)-0.5,(float)0.5,(float)0.9},
	{(float)-0.5,(float)-0.5,0},
	{(float)0.5,(float)-0.5,0},
	{(float)0.5,(float)-0.5,(float)0.3},
	{(float)0.2,(float)-0.5,(float)0.3},
	{(float)-0.1,(float)-0.5,(float)0.3},
	{(float)-0.5,(float)-0.5,(float)0.3},
	{(float)0.2,(float)-0.5,(float)0.6},
	{(float)-0.1,(float)-0.5,(float)0.6},
	{(float)-0.1,(float)-0.5,(float)0.9},
	{(float)-0.5,(float)-0.5,(float)0.9}
};

/* Definition der vorhandenen Kanten */
struct Edge edges[] =
{
	{&vertices[0],&vertices[1]},
	{&vertices[1],&vertices[2]},
	{&vertices[2],&vertices[3]},
	{&vertices[3],&vertices[4]},
	{&vertices[4],&vertices[5]},
	{&vertices[5],&vertices[0]},
	{&vertices[0],&vertices[6]},
	{&vertices[1],&vertices[7]},
	{&vertices[2],&vertices[8]},
	{&vertices[3],&vertices[9]},
	{&vertices[4],&vertices[10]},
	{&vertices[5],&vertices[11]},
	{&vertices[6],&vertices[7]},
	{&vertices[7],&vertices[8]},
	{&vertices[8],&vertices[9]},
	{&vertices[9],&vertices[10]},
	{&vertices[10],&vertices[11]},
	{&vertices[11],&vertices[6]},
	{&vertices[6],&vertices[12]},
	{&vertices[7],&vertices[13]},
	{&vertices[8],&vertices[14]},
	{&vertices[9],&vertices[15]},
	{&vertices[10],&vertices[16]},
	{&vertices[11],&vertices[17]},
	{&vertices[12],&vertices[13]},
	{&vertices[13],&vertices[14]},
	{&vertices[14],&vertices[15]},
	{&vertices[15],&vertices[16]},
	{&vertices[16],&vertices[17]},
	{&vertices[17],&vertices[12]},
	{&vertices[0],&vertices[2]},
	{&vertices[3],&vertices[5]},
	{&vertices[6],&vertices[8]},
	{&vertices[9],&vertices[11]},
	{&vertices[12],&vertices[14]},
	{&vertices[15],&vertices[17]},

	{&vertices[18],&vertices[19]},	// 36
	{&vertices[19],&vertices[20]},
	{&vertices[20],&vertices[21]},
	{&vertices[21],&vertices[18]},
	{&vertices[18],&vertices[20]},
	{&vertices[18],&vertices[22]},
	{&vertices[19],&vertices[23]},
	{&vertices[20],&vertices[24]},
	{&vertices[21],&vertices[25]},
	{&vertices[22],&vertices[23]},
	{&vertices[23],&vertices[24]},
	{&vertices[24],&vertices[25]},
	{&vertices[25],&vertices[22]},
	{&vertices[22],&vertices[24]},

	{&vertices[26],&vertices[27]},	// 50
	{&vertices[27],&vertices[28]},
	{&vertices[28],&vertices[29]},
	{&vertices[29],&vertices[30]},
	{&vertices[31],&vertices[26]},
	{&vertices[27],&vertices[31]},
	{&vertices[28],&vertices[30]},
	{&vertices[27],&vertices[38]},
	{&vertices[28],&vertices[41]},
	{&vertices[38],&vertices[41]},
	{&vertices[30],&vertices[43]},
	{&vertices[40],&vertices[41]},
	{&vertices[40],&vertices[43]},
	{&vertices[39],&vertices[42]},
	{&vertices[39],&vertices[40]},
	{&vertices[38],&vertices[39]},
	{&vertices[30],&vertices[41]},
	{&vertices[31],&vertices[38]},
	{&vertices[31],&vertices[42]},
	{&vertices[44],&vertices[48]},
	{&vertices[48],&vertices[49]},
	{&vertices[44],&vertices[47]},
	{&vertices[47],&vertices[49]},
	{&vertices[46],&vertices[47]},
	{&vertices[45],&vertices[46]},
	{&vertices[44],&vertices[45]},
	{&vertices[34],&vertices[49]},
	{&vertices[34],&vertices[46]},
	{&vertices[33],&vertices[48]},
	{&vertices[33],&vertices[45]},
	{&vertices[52],&vertices[53]},
	{&vertices[36],&vertices[52]},
	{&vertices[36],&vertices[55]},
	{&vertices[53],&vertices[55]},
	{&vertices[50],&vertices[53]},
	{&vertices[54],&vertices[55]},
	{&vertices[50],&vertices[54]},
	{&vertices[50],&vertices[51]},
	{&vertices[51],&vertices[52]},
	{&vertices[37],&vertices[51]},
	{&vertices[37],&vertices[54]},
	{&vertices[46],&vertices[52]},
	{&vertices[45],&vertices[51]},
	{&vertices[34],&vertices[35]},
	{&vertices[35],&vertices[36]},
	{&vertices[34],&vertices[36]},
	{&vertices[33],&vertices[37]},
	{&vertices[32],&vertices[37]},
	{&vertices[32],&vertices[33]},
	{&vertices[27],&vertices[33]},
	{&vertices[26],&vertices[32]},
	{&vertices[28],&vertices[49]},
	{&vertices[27],&vertices[48]},
	{&vertices[29],&vertices[35]},
	{&vertices[28],&vertices[34]},
	{&vertices[30],&vertices[36]},
	{&vertices[29],&vertices[35]},
	{&vertices[42],&vertices[43]},
	{&vertices[42],&vertices[52]},
	{&vertices[43],&vertices[55]},
	{&vertices[31],&vertices[37]},
	
	{&vertices[56],&vertices[57]},	// 111
	{&vertices[57],&vertices[67]},
	{&vertices[66],&vertices[67]},
	{&vertices[56],&vertices[66]},
	{&vertices[56],&vertices[61]},
	{&vertices[58],&vertices[61]},
	{&vertices[57],&vertices[58]},
	{&vertices[66],&vertices[71]},
	{&vertices[68],&vertices[71]},
	{&vertices[67],&vertices[68]},
	{&vertices[59],&vertices[60]},
	{&vertices[60],&vertices[63]},
	{&vertices[62],&vertices[63]},
	{&vertices[59],&vertices[62]},
	{&vertices[69],&vertices[70]},
	{&vertices[70],&vertices[73]},
	{&vertices[72],&vertices[73]},
	{&vertices[69],&vertices[72]},
	{&vertices[60],&vertices[61]},
	{&vertices[61],&vertices[65]},
	{&vertices[64],&vertices[65]},
	{&vertices[63],&vertices[64]},
	{&vertices[70],&vertices[71]},
	{&vertices[71],&vertices[75]},
	{&vertices[74],&vertices[75]},
	{&vertices[73],&vertices[74]},
	{&vertices[65],&vertices[75]},
	{&vertices[64],&vertices[74]},
	{&vertices[63],&vertices[73]},
	{&vertices[62],&vertices[72]},
	{&vertices[58],&vertices[59]},
	{&vertices[59],&vertices[69]},
	{&vertices[68],&vertices[69]},
	{&vertices[58],&vertices[68]},
	{&vertices[66],&vertices[75]},
	{&vertices[56],&vertices[65]},
};

/* Definition der vorhandenen Flchen */

#define A1 (float)0.821994937
#define A2 (float)0.569494797
#define A3 (float)0.92018598
#define A4 (float)0.391481496
#define A5 (float)0.804842006
#define A6 (float)0.557610901
#define A7 (float)0.203222607
#define A8 (float)0.911921505
#define A9 (float)0.410364677
#define A10 (float)0.759184147
#define A11 (float)0.525978209
#define A12 (float)0.383387994

/*#define A3 (float)0.456584116
#define A4 (float)0.889680249
#define A5 (float)0.808287009
#define A6 (float)0.559997667
#define A7 (float)0.181864577
#define A8 (float)0.248547906
#define A9 (float)0.968619604
#define A10 (float)0.770943345
#define A11 (float)0.534125217
#define A12 (float)0.346924505*/

#define B1 (float)0.447213596
#define B2 (float)0.894427191

#define C1 (float)0.999962874
#define C2 (float)0.008616848

struct Face faces[] =
{
	/* Flasche */
	{&faces[1],{&edges[0],&edges[1],&edges[30],NULL},0,0,-1,COL_GREEN,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[2],{&edges[30],&edges[2],&edges[31],&edges[5]},0,0,-1,COL_GREEN,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[3],{&edges[3],&edges[4],&edges[31],NULL},0,0,-1,COL_GREEN,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[4],{&edges[0],&edges[7],&edges[12],&edges[6]},(float)8.660254,5,0,COL_GREEN,
	{{A1,A2,0,1,0,0},{1,0,0,A3,0,A4},{A5,A6,A7,A3,0,A4},{A1,A2,0,A5,A6,A7}}},
	{&faces[5],{&edges[1],&edges[8],&edges[13],&edges[7]},(float)8.660254,-5,0,COL_GREEN,
	{{1,0,0,A1,-A2,0},{A1,-A2,0,A5,-A6,A7},{A3,0,A4,A5,-A6,A7},{1,0,0,A3,0,A4}}},
	{&faces[6],{&edges[2],&edges[9],&edges[14],&edges[8]},0,-1,0,COL_GREEN,
	{{A1,-A2,0,-A1,-A2,0},{-A1,-A2,0,-A5,-A6,A7},{A5,-A6,A7,-A5,-A6,A7},{A1,-A2,0,A5,-A6,A7}}},
	{&faces[7],{&edges[3],&edges[10],&edges[15],&edges[9]},(float)-8.660254,-5,0,COL_GREEN,
	{{-A1,-A2,0,-1,0,0},{-1,0,0,-A3,0,A4},{-A5,-A6,A7,-A3,0,A4},{-A1,-A2,0,-A5,-A6,A7}}},
	{&faces[8],{&edges[4],&edges[11],&edges[16],&edges[10]},(float)-8.660254,5,0,COL_GREEN,
	{{-1,0,0,-A1,A2,0},{-A1,A2,0,-A5,A6,A7},{-A3,0,A4,-A5,A6,A7},{-1,0,0,-A3,0,A4}}},
	{&faces[9],{&edges[5],&edges[6],&edges[17],&edges[11]},0,1,0,COL_GREEN,
	{{-A1,A2,0,A1,A2,0},{A1,A2,0,A5,A6,A7},{-A5,A6,A7,A5,A6,A7},{-A1,A2,0,-A5,A6,A7}}},
	{&faces[10],{&edges[12],&edges[19],&edges[24],&edges[18]},(float)8.660254,5,(float)3.897114317,COL_GREEN,
	{{A5,A6,A7,A3,0,A4},{A3,0,A4,A8,0,A9},{A10,A11,A12,A8,0,A9},{A5,A6,A7,A10,A11,A12}}},
	{&faces[11],{&edges[13],&edges[20],&edges[25],&edges[19]},(float)8.660254,-5,(float)3.897114317,COL_GREEN,
	{{A3,0,A4,A5,-A6,A7},{A5,-A6,A7,A10,-A11,A12},{A8,0,A9,A10,-A11,A12},{A3,0,A4,A8,0,A9}}},
	{&faces[12],{&edges[14],&edges[21],&edges[26],&edges[20]},0,-1,(float)0.47631397,COL_GREEN,
	{{A5,-A6,A7,-A5,-A6,A7},{-A5,-A6,A7,-A10,-A11,A12},{A10,-A11,A12,-A10,-A11,A12},{A5,-A6,A7,A10,-A11,A12}}},
	{&faces[13],{&edges[15],&edges[22],&edges[27],&edges[21]},(float)-8.660254,-5,(float)3.897114317,COL_GREEN,
	{{-A5,-A6,A7,-A3,0,A4},{-A3,0,A4,-A8,0,A9},{-A10,-A11,A12,-A8,0,A9},{-A5,-A6,A7,-A10,-A11,A12}}},
	{&faces[14],{&edges[16],&edges[23],&edges[28],&edges[22]},(float)-8.660254,5,(float)3.897114317,COL_GREEN,
	{{-A3,0,A4,-A5,A6,A7},{-A5,A6,A7,-A10,A11,A12},{-A8,0,A9,-A10,A11,A12},{-A3,0,A4,-A8,0,A9}}},
	{&faces[15],{&edges[17],&edges[18],&edges[29],&edges[23]},0,1,(float)0.47631397,COL_GREEN,
	{{-A5,A6,A7,A5,A6,A7},{A5,A6,A7,A10,A11,A12},{-A10,A11,A12,A10,A11,A12},{-A5,A6,A7,-A10,A11,A12}}},
	{&faces[16],{&edges[24],&edges[25],&edges[34],NULL},0,0,1,COL_GREEN,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},
	{&faces[17],{&edges[34],&edges[26],&edges[35],&edges[29]},0,0,1,COL_GREEN,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{NULL,{&edges[27],&edges[28],&edges[35],NULL},0,0,1,COL_GREEN,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},

	/* Dose */
	{&faces[19],{&edges[0],&edges[1],&edges[30],NULL},0,0,-1,COL_GREY,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[20],{&edges[30],&edges[2],&edges[31],&edges[5]},0,0,-1,COL_GREY,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[21],{&edges[3],&edges[4],&edges[31],NULL},0,0,-1,COL_GREY,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[22],{&edges[0],&edges[7],&edges[12],&edges[6]},(float)8.660254,5,0,COL_RED,
	{{A1,A2,0,1,0,0},{1,0,0,1,0,0},{A1,A2,0,1,0,0},{A1,A2,0,A1,A2,0}}},
	{&faces[23],{&edges[1],&edges[8],&edges[13],&edges[7]},(float)8.660254,-5,0,COL_RED,
	{{1,0,0,A1,-A2,0},{A1,-A2,0,A1,-A2,0},{1,0,0,A1,-A2,0},{1,0,0,1,0,0}}},
	{&faces[24],{&edges[2],&edges[9],&edges[14],&edges[8]},0,-1,0,COL_RED,
	{{A1,-A2,0,-A1,-A2,0},{-A1,-A2,0,-A1,-A2,0},{A1,-A2,0,-A1,-A2,0},{A1,-A2,0,A1,-A2,0}}},
	{&faces[25],{&edges[3],&edges[10],&edges[15],&edges[9]},(float)-8.660254,-5,0,COL_RED,
	{{-A1,-A2,0,-1,0,0},{-1,0,0,-1,0,0},{-A1,-A2,0,-1,0,0},{-A1,-A2,0,-A1,-A2,0}}},
	{&faces[26],{&edges[4],&edges[11],&edges[16],&edges[10]},(float)-8.660254,5,0,COL_RED,
	{{-1,0,0,-A1,A2,0},{-A1,A2,0,-A1,A2,0},{-1,0,0,-A1,A2,0},{-1,0,0,-1,0,0}}},
	{&faces[27],{&edges[5],&edges[6],&edges[17],&edges[11]},0,1,0,COL_RED,
	{{-A1,A2,0,A1,A2,0},{A1,A2,0,A1,A2,0},{-A1,A2,0,A1,A2,0},{-A1,A2,0,-A1,A2,0}}},
	{&faces[28],{&edges[12],&edges[13],&edges[32],NULL},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},
	{&faces[29],{&edges[32],&edges[14],&edges[33],&edges[17]},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{NULL,{&edges[15],&edges[16],&edges[33],NULL},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},

	/* Kse */
	{&faces[31],{&edges[40],&edges[38],&edges[39],NULL},0,0,-1,COL_YELLOW,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[32],{&edges[40],&edges[36],&edges[37],NULL},0,0,-1,COL_RED,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,0,0,0,0}}},
	{&faces[33],{&edges[41],&edges[48],&edges[44],&edges[39]},-1,2,0,COL_YELLOW,
	{{-B1,B2,0,-B1,B2,0},{-B1,B2,0,-B1,B2,0},{-B1,B2,0,-B1,B2,0},{-B1,B2,0,-B1,B2,0}}},
	{&faces[34],{&edges[36],&edges[42],&edges[45],&edges[41]},2,1,0,COL_RED,
	{{B2,B1,0,1,0,0},{1,0,0,1,0,0},{B2,B1,0,1,0,0},{B2,B1,0,B2,B1,0}}},
	{&faces[35],{&edges[37],&edges[43],&edges[46],&edges[42]},2,-1,0,COL_RED,
	{{1,0,0,B2,-B1,0},{B2,-B1,0,B2,-B1,0},{1,0,0,B2,-B1,0},{1,0,0,1,0,0}}},
	{&faces[36],{&edges[38],&edges[44],&edges[47],&edges[43]},-1,-2,0,COL_YELLOW,
	{{-B1,-B2,0,-B1,-B2,0},{-B1,-B2,0,-B1,-B2,0},{-B1,-B2,0,-B1,-B2,0},{-B1,-B2,0,-B1,-B2,0}}},
	{&faces[37],{&edges[49],&edges[47],&edges[48],NULL},0,0,1,COL_YELLOW,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},
	{NULL,{&edges[45],&edges[46],&edges[49],NULL},0,0,1,COL_RED,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,0,0,0,0}}},

	/* Schlssel */
	{&faces[39],{&edges[50],&edges[54],&edges[55],NULL},1,0,0,COL_YELLOW,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[40],{&edges[56],&edges[53],&edges[52],NULL},1,0,0,COL_YELLOW,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[41],{&edges[51],&edges[57],&edges[59],&edges[58]},1,0,0,COL_YELLOW,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[42],{&edges[66],&edges[61],&edges[62],&edges[60]},0,0,1,COL_YELLOW,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[43],{&edges[67],&edges[65],&edges[63],&edges[68]},0,0,-1,COL_YELLOW,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[44],{&edges[65],&edges[64],&edges[61],&edges[59]},0,-1,0,COL_YELLOW,
	{{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0}}},
	{&faces[45],{&edges[62],&edges[64],&edges[63],&edges[107]},-1,0,0,COL_YELLOW,
	{{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0}}},
	{&faces[46],{&edges[69],&edges[70],&edges[72],&edges[71]},1,0,0,COL_YELLOW,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[47],{&edges[73],&edges[74],&edges[75],&edges[71]},0,1,0,COL_YELLOW,
	{{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0}}},
	{&faces[48],{&edges[73],&edges[72],&edges[76],&edges[77]},0,0,1,COL_YELLOW,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[49],{&edges[78],&edges[79],&edges[75],&edges[69]},0,0,-1,COL_YELLOW,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[50],{&edges[80],&edges[81],&edges[82],&edges[83]},0,0,1,COL_YELLOW,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[51],{&edges[84],&edges[83],&edges[85],&edges[86]},1,0,0,COL_YELLOW,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[52],{&edges[87],&edges[88],&edges[80],&edges[84]},0,-1,0,COL_YELLOW,
	{{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0}}},
	{&faces[53],{&edges[87],&edges[89],&edges[90],&edges[86]},0,0,-1,COL_YELLOW,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[54],{&edges[74],&edges[91],&edges[88],&edges[92]},-1,0,0,COL_YELLOW,
	{{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0}}},
	{&faces[55],{&edges[93],&edges[94],&edges[95],NULL},-1,0,0,COL_YELLOW,
	{{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0}}},
	{&faces[56],{&edges[96],&edges[97],&edges[98],NULL},-1,0,0,COL_YELLOW,
	{{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0}}},
	{&faces[57],{&edges[50],&edges[99],&edges[98],&edges[100]},0,(float)0.005,(float)-0.008660254,COL_YELLOW,
	{{0,0,-1,0,C1,-C2},{0,C1,-C2,0,C1,-C2},{0,0,-1,0,C1,-C2},{0,0,-1,0,0,-1}}},
	{&faces[58],{&edges[51],&edges[101],&edges[70],&edges[102]},0,1,0,COL_YELLOW,
	{{0,C1,-C2,0,C1,C2},{0,C1,C2,0,C1,C2},{0,C1,-C2,0,C1,C2},{0,C1,-C2,0,C1,-C2}}},
	{&faces[59],{&edges[52],&edges[103],&edges[93],&edges[104]},0,(float)0.005,(float)0.008660254,COL_YELLOW,
	{{0,C1,C2,0,0,1},{0,0,1,0,0,1},{0,C1,C2,0,0,1},{0,C1,C2,0,C1,C2}}},
	{&faces[60],{&edges[53],&edges[105],&edges[94],&edges[106]},0,(float)-0.005,(float)0.008660254,COL_YELLOW,
	{{0,0,1,0,-C1,C2},{0,-C1,C2,0,-C1,C2},{0,0,1,0,-C1,C2},{0,0,1,0,0,1}}},
	{&faces[61],{&edges[107],&edges[108],&edges[85],&edges[109]},0,-1,0,COL_YELLOW,
	{{0,-C1,-C2,0,-C1,C2},{0,-C1,-C2,0,-C1,-C2},{0,-C1,-C2,0,-C1,C2},{0,-C1,C2,0,-C1,C2}}},
	{NULL,{&edges[54],&edges[100],&edges[97],&edges[110]},0,(float)-0.005,(float)-0.008660254,COL_YELLOW,
	{{0,-C1,-C2,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,-C1,-C2},{0,-C1,-C2,0,-C1,-C2}}},

	/* Stiegen */
	{&faces[63],{&edges[111],&edges[112],&edges[113],&edges[114]},0,0,-1,COL_GREY,
	{{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1},{0,0,-1,0,0,-1}}},
	{&faces[64],{&edges[111],&edges[115],&edges[116],&edges[117]},0,1,0,COL_GREY,
	{{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0}}},
	{&faces[65],{&edges[113],&edges[118],&edges[119],&edges[120]},0,-1,0,COL_GREY,
	{{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0}}},
	{&faces[66],{&edges[121],&edges[122],&edges[123],&edges[124]},0,1,0,COL_GREY,
	{{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0}}},
	{&faces[67],{&edges[125],&edges[126],&edges[127],&edges[128]},0,-1,0,COL_GREY,
	{{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0}}},
	{&faces[68],{&edges[129],&edges[130],&edges[131],&edges[132]},0,1,0,COL_GREY,
	{{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0},{0,1,0,0,1,0}}},
	{&faces[69],{&edges[133],&edges[134],&edges[135],&edges[136]},0,-1,0,COL_GREY,
	{{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0},{0,-1,0,0,-1,0}}},
	{&faces[70],{&edges[131],&edges[137],&edges[135],&edges[138]},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[71],{&edges[123],&edges[139],&edges[127],&edges[140]},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[72],{&edges[141],&edges[142],&edges[143],&edges[144]},0,0,1,COL_GREY,
	{{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1},{0,0,1,0,0,1}}},
	{&faces[73],{&edges[117],&edges[144],&edges[120],&edges[112]},1,0,0,COL_GREY,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[74],{&edges[124],&edges[140],&edges[128],&edges[142]},1,0,0,COL_GREY,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{&faces[75],{&edges[132],&edges[138],&edges[136],&edges[139]},1,0,0,COL_GREY,
	{{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0},{1,0,0,1,0,0}}},
	{NULL,{&edges[114],&edges[145],&edges[137],&edges[146]},-1,0,0,COL_GREY,
	{{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0},{-1,0,0,-1,0,0}}}
};

struct ObjList
{
	struct ObjList *next;
	float x,y;
	float dist;		// Entfernung vom Augpunkt
	int startCol, endCol, aktCol;
	struct Object *obj;
};

/* Definition der Objekte */
struct Object objects[] =
{
	&faces[0],
	&faces[18],
	&faces[30],
	&faces[38],
	&faces[62]
};

struct ObjList *aktObjList=NULL, *drawObjList=NULL;

#endif